//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <Grids.hpp>
#include <Math.h>

#include "Main.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TForm1 *Form1;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
   mSelected = false;

   cbWoj           = new TComboBox(Owner);
   cbWoj->Parent   = this;
   cbWoj->Visible  = false;
	cbWoj->Style    = csDropDown;
   cbWoj->OnChange = cbWojChange;
}
//---------------------------------------------------------------------------
__fastcall TForm1::~TForm1(void)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Image1Click(TObject *Sender)
{
	Koniec();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Koniec()
{
	if(Application->MessageBoxA("Koniec pracy",
                               "Uwaga",
                               MB_YESNO | MB_ICONEXCLAMATION) == IDYES)
   {
      Application->Terminate();
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Buduj_sg()
{
   int wiersz = 0;

	sg->DefaultRowHeight = 19;

   sg->ColCount = COLS;
   wiersz = 0;

   // NAGWKI KOLUMN
   sg->Cells[ 0][wiersz] = "Lp";
   sg->Cells[ 1][wiersz] = "Nazwisko";
   sg->Cells[ 2][wiersz] = "Imi";
   sg->Cells[ 3][wiersz] = "Ulica i nr";
   sg->Cells[ 4][wiersz] = "Kod p->";
   sg->Cells[ 5][wiersz] = "Miejscowo";
   sg->Cells[ 6][wiersz] = "Data ur->";
   sg->Cells[ 7][wiersz] = "Pesel";
   sg->Cells[ 8][wiersz] = "Telefon";
   sg->Cells[ 9][wiersz] = "E-mail";
   sg->Cells[10][wiersz] = "Wojewdztwo";
   sg->Cells[11][wiersz] = "Zarobek";
   ++wiersz;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "1";
   sg->Cells[ 1][wiersz] = "Kowalski";
   sg->Cells[ 2][wiersz] = "Jan";
   sg->Cells[ 3][wiersz] = "Mikoowska 122";
   sg->Cells[ 4][wiersz] = "43-200";
   sg->Cells[ 5][wiersz] = "Pszczyna";
   sg->Cells[ 6][wiersz] = "1990-01-01";
   sg->Cells[ 7][wiersz] = "11111111111";
   sg->Cells[ 8][wiersz] = "2223001";
   sg->Cells[ 9][wiersz] = "kowlaskij@op->pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "1200,00";
   ++wiersz;
   sg->RowCount = sg->RowCount + 1;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "2";
   sg->Cells[ 1][wiersz] = "Kumierkiewicz";
   sg->Cells[ 2][wiersz] = "Iwona";
   sg->Cells[ 3][wiersz] = "Jankowicka 123";
   sg->Cells[ 4][wiersz] = "43-200";
   sg->Cells[ 5][wiersz] = "Pszczyna";
   sg->Cells[ 6][wiersz] = "1956-11-24";
   sg->Cells[ 7][wiersz] = "22222222222";
   sg->Cells[ 8][wiersz] = "2223002";
   sg->Cells[ 9][wiersz] = "iwonak@op->pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "1300,00";
   ++wiersz;
   sg->RowCount = sg->RowCount + 1;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "3";
   sg->Cells[ 1][wiersz] = "Lena";
   sg->Cells[ 2][wiersz] = "Beata";
   sg->Cells[ 3][wiersz] = "Konfederatw Barskich 11/8";
   sg->Cells[ 4][wiersz] = "43-100";
   sg->Cells[ 5][wiersz] = "Tychy";
   sg->Cells[ 6][wiersz] = "1987-12-31";
   sg->Cells[ 7][wiersz] = "55555555555";
   sg->Cells[ 8][wiersz] = "5555003";
   sg->Cells[ 9][wiersz] = "borowskia@op->pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "1400,00";
   ++wiersz;
   sg->RowCount = sg->RowCount + 1;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "4";
   sg->Cells[ 1][wiersz] = "Kowalska";
   sg->Cells[ 2][wiersz] = "Renata";
   sg->Cells[ 3][wiersz] = "Jankowicka 124";
   sg->Cells[ 4][wiersz] = "43-200";
   sg->Cells[ 5][wiersz] = "Pszczyna";
   sg->Cells[ 6][wiersz] = "1970-12-31";
   sg->Cells[ 7][wiersz] = "33333333333";
   sg->Cells[ 8][wiersz] = "2223004";
   sg->Cells[ 9][wiersz] = "kasiak@op->pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "1500,00";
   ++wiersz;
   sg->RowCount = sg->RowCount + 1;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "5";
   sg->Cells[ 1][wiersz] = "Trgolewska";
   sg->Cells[ 2][wiersz] = "Beata";
   sg->Cells[ 3][wiersz] = "Jankowicka 125";
   sg->Cells[ 4][wiersz] = "43-200";
   sg->Cells[ 5][wiersz] = "Pszczyna";
   sg->Cells[ 6][wiersz] = "1965-10-28";
   sg->Cells[ 7][wiersz] = "44444444444";
   sg->Cells[ 8][wiersz] = "2223005";
   sg->Cells[ 9][wiersz] = "beatat@op->pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "1600,00";
   ++wiersz;
   sg->RowCount = sg->RowCount + 1;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "6";
   sg->Cells[ 1][wiersz] = "Rudkiewicz";
   sg->Cells[ 2][wiersz] = "Wiesaw";
   sg->Cells[ 3][wiersz] = "Jankowicka";
   sg->Cells[ 4][wiersz] = "43-200";
   sg->Cells[ 5][wiersz] = "Pszczyna";
   sg->Cells[ 6][wiersz] = "1965-10-28";
   sg->Cells[ 7][wiersz] = "44444444444";
   sg->Cells[ 8][wiersz] = "2223006";
   sg->Cells[ 9][wiersz] = "galanonim@op->pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "1700,00";
   ++wiersz;
   sg->RowCount = sg->RowCount + 1;

   // Dane osoby
   sg->Cells[ 0][wiersz] = "7";
   sg->Cells[ 1][wiersz] = "Staniszewski";
   sg->Cells[ 2][wiersz] = "Bronisaw";
   sg->Cells[ 3][wiersz] = "Jankowicka 127";
   sg->Cells[ 4][wiersz] = "43-200";
   sg->Cells[ 5][wiersz] = "Pszczyna";
   sg->Cells[ 6][wiersz] = "1965-10-27";
   sg->Cells[ 7][wiersz] = "44444444444";
   sg->Cells[ 8][wiersz] = "2223007";
   sg->Cells[ 9][wiersz] = "bronislaws@op.pl";
   sg->Cells[10][wiersz] = "lskie";
   sg->Cells[11][wiersz] = "12000,00";
	++wiersz;

	sg->RowCount = wiersz;
   // nie chc pustego wiersza na kocu
   // sg->RowCount = sg->RowCount + 1;

   sg->FixedCols = 1;
   sg->FixedRows = 1;

   sg->ColWidths[ 0] =  20;     // Lp
   sg->ColWidths[ 1] =  90;     // Nazwisko
   sg->ColWidths[ 2] =  60;     // Imie
   sg->ColWidths[ 3] = 150;     // Ulica i nr
   sg->ColWidths[ 4] =  60;     // Kod p
   sg->ColWidths[ 5] = 130;     // Miejscowosc
   sg->ColWidths[ 6] =  60;     // Data ur
   sg->ColWidths[ 7] =  80;     // Pesel
   sg->ColWidths[ 8] =  60;     // Telefon
   sg->ColWidths[ 9] = 100;     // E-mail
   sg->ColWidths[10] = 100;     // Wojewdztwo
   sg->ColWidths[11] =  70;     // Zarobek

   // wczenie opcji
	sg->Options = sg->Options << goFixedVertLine    <<
                                goFixedHorzLine    <<
                                goVertLine         <<
                                goHorzLine         <<
                                goRangeSelect      <<
                                goRowSizing        <<
                                goColSizing        <<
                                goRowMoving        <<
                                goEditing          <<
										  goAlwaysShowEditor <<
                                goColMoving;

   // wyczenie wybranych opcji
   sg->Options = sg->Options >> goAlwaysShowEditor;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
	Buduj_sg();
	sg->Align = alClient;

   sg->Col = 1;
   sg->Row = 1;
   sg->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Przypisz_lp()
{
   int ACol          = 0;
   int ilosc_wierszy = 0;
 	int wiersz        = 0;

	ilosc_wierszy = sg->RowCount;

   for(wiersz = 1; wiersz < ilosc_wierszy; wiersz++)
   {
   	sg->Cells[ACol][wiersz] = IntToStr(wiersz);
   }
   sg->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgSelectCell(TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	mSelected = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
   cbWoj->Clear();

   cbWoj->Items->Add("dolnolskie");
   cbWoj->Items->Add("kujawsko-pomorskie");
   cbWoj->Items->Add("lubelskie");
   cbWoj->Items->Add("lubuskie");
   cbWoj->Items->Add("dzkie");
   cbWoj->Items->Add("maopolskie");
   cbWoj->Items->Add("mazowieckie");
   cbWoj->Items->Add("opolskie");
   cbWoj->Items->Add("podkarpackie");
   cbWoj->Items->Add("podlaskie");
   cbWoj->Items->Add("pomorskie");
   cbWoj->Items->Add("lskie");
   cbWoj->Items->Add("witokrzyskie");
   cbWoj->Items->Add("warmisko-mazurskie");
   cbWoj->Items->Add("wielkopolskie");
   cbWoj->Items->Add("zachodniopomorskie");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgDrawCell(TObject *Sender, int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
	bool       inny_kolor = false;
   AnsiString txt        = "";
	int        x          = 0;
	int        y          = 0;

	if(ARow == 0 || ACol == 0)
   {
		return;
   }

   // co drugi rzd w innym kolorze
	inny_kolor = fmod(ARow, 2);
	
	// ramka wok aktywnej celi
	if(State.Contains(gdFocused))
   {
		DrawRectGrid(Rect);
   }

   // co drugi wiersz w innym kolorze
   if (inny_kolor)
   {
	   if(!State.Contains(gdFocused))
      {
      	txt = sg->Cells[ACol][ARow];

			// kolor niestandardowy
         sg->Canvas->Brush->Color = 0x00D6EAEF;

         sg->Canvas->FillRect(Rect);

         x = Rect.Left + 2;
         y = (Rect.Top + Rect.Bottom - sg->Canvas->TextHeight(txt)) / 2;
         sg->Canvas->TextOutA(x, y, txt);
      }
   }
}
//---------------------------------------------------------------------------
void TForm1::set_cbWoj(AnsiString &txt)
{
	// ustawia cxbWoj->Text na to co jest aktualnie w celi
	int ilEl = cbWoj->Items->Count - 1;

   if(ilEl < 0) return;

	int        lp   = 0;
   AnsiString txt2 = "";

	cbWoj->ItemIndex = -1;
   for(lp = 0; lp < ilEl; lp++)
   {
		txt2 = cbWoj->Items->Strings[lp];
      if(txt == txt2)
      {
			cbWoj->ItemIndex = lp;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgClick(TObject *Sender)
{
	if(sg->Col == colWoj)
   {
		AnsiString txt  = "";
      int        ARow = sg->Row;
      int        ACol = sg->Col;

      txt = sg->Cells[ACol][ARow];

      // ustaw cbWoj na to co jest w Celi
      set_cbWoj(txt);

      Rysuj_cbWoj();
      cbWoj->DroppedDown = false;
   }
   else
   {
	   cbWoj->Visible = false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Rysuj_cbWoj(void)
{
	TRect Rect = sg->CellRect(sg->Col, sg->Row);

   cbWoj->Visible = false;

   cbWoj->Top     = sg->Top + Rect.Top + sg->GridLineWidth;
   cbWoj->Left    = sg->Left + Rect.Left + sg->GridLineWidth;
   cbWoj->Height  = (Rect.Bottom - Rect.Top) + 1;
   cbWoj->Width   = (Rect.Right - Rect.Left) + 1;

   cbWoj->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cbWojChange(TObject *Sender)
{
	sg->Cells[sg->Col][sg->Row] = cbWoj->Items->Strings[cbWoj->ItemIndex];
   cbWoj->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DrawRectGrid(TRect &Rect)
{
	if(mSelected)
   {
		sg->Repaint();
      mSelected = false;
   }

   sg->Canvas->Brush->Style = bsClear;
   sg->Canvas->Pen->Color   = clBlue;
   sg->Canvas->Pen->Width   = 2;
   sg->Canvas->Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
}
//---------------------------------------------------------------------------

